/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core.build;

import com.aptana.core.IMap;
import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.Problem;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.index.core.build.BuildContext;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.parsing.ast.IParseError;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class JSParserValidator
extends AbstractBuildParticipant {
    public static final String ID = "com.aptana.js.core.JSParserValidator";
    private List<IProblem> fProblems;
    private Document fDocument;
    private URI fLocation;
    private String fPath;
    private BuildContext fContext;

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.js.core.problem");
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        try {
            context.getAST();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fContext = context;
        this.fLocation = context.getURI();
        this.fPath = this.fLocation.toString();
        this.fProblems = new ArrayList<IProblem>();
        try {
            Collection parseErrors = context.getParseErrors();
            if (!CollectionsUtil.isEmpty((Collection)parseErrors)) {
                this.fProblems.addAll(CollectionsUtil.map((Collection)parseErrors, (IMap)new IMap<IParseError, IProblem>(){

                    public IProblem map(IParseError parseError) {
                        return new Problem(parseError.getSeverity().intValue(), parseError.getMessage(), parseError.getOffset(), parseError.getLength(), JSParserValidator.this.getLine(parseError.getOffset()), JSParserValidator.this.fPath);
                    }
                }));
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (String)MessageFormat.format("Failed to parse {0} for JS Parser Validation", this.fPath), (Throwable)e);
        }
        context.putProblems("com.aptana.js.core.problem", this.fProblems);
        this.fDocument = null;
        this.fPath = null;
        this.fLocation = null;
        this.fContext = null;
    }

    private int getLine(int offset) {
        try {
            return this.getDocument(this.fContext).getLineOfOffset(offset) + 1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private IDocument getDocument(BuildContext context) {
        if (this.fDocument == null) {
            String source = context.getContents();
            this.fDocument = new Document(source);
        }
        return this.fDocument;
    }
}

